/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class VWEndTimerParamPanel
extends JPanel
implements IVWExpressionTextFieldListener {
    private GridBagConstraints m_gbCons = null;
    protected VWToolbarBorder m_timerBorder = null;
    protected VWExpressionTextField m_timerTextField = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initTimerControls();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.m_instructionDef = instructionDef;
        this.m_timerTextField.removeExpressionTextFieldListener(this);
        if (this.m_instructionDef != null) {
            this.m_timerTextField.setText(VWInstruction.EndTimerInstructionGetTime(this.m_instructionDef));
        } else {
            this.m_timerTextField.setText("");
        }
        this.m_timerTextField.addExpressionTextFieldListener(this);
    }

    private void initTimerControls() {
        this.m_timerBorder = new VWToolbarBorder(VWResource.s_timerNameExpressionStr, 0);
        JPanel clientPanel = this.m_timerBorder.getClientPanel();
        clientPanel.setLayout(new GridLayout());
        this.m_timerTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_timerTextField.addExpressionTextFieldListener(this);
        clientPanel.add(this.m_timerTextField);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.m_timerBorder, this.m_gbCons);
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        this.updateTimerName();
    }

    private void updateTimerName() {
        try {
            String timerName = this.m_timerTextField.getText();
            VWInstruction.EndTimerInstructionSetTime(this.m_instructionDef, timerName);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

